unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, DBGrids, StdCtrls, Buttons, ExtCtrls,
  DataModule,
  UDrukowanie;

type
  TFMain = class(TForm)
    Panel1: TPanel;
    Shape: TShape;
    Label1: TLabel;
    btnCLOSE: TBitBtn;
    DBGrid1: TDBGrid;
    btnDRUKUJ: TButton;
    procedure btnDRUKUJClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure btnCLOSEClick(Sender: TObject);

  private
    procedure  Drukuj(LNazwisko : TStringList;
                      LImie     : TStringList;
                      LUlica    : TStringList;
                      LKodp     : TStringList;
                      LMiasto   : TStringList);

  public
    procedure  Start();
  end;

var
  FMain: TFMain;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TFMain.btnCLOSEClick(Sender: TObject);
begin
	Close();
end;

procedure TFMain.btnDRUKUJClick(Sender: TObject);
begin
	Start();
end;

procedure TFMain.FormActivate(Sender: TObject);
begin
	Shape.Brush.Color := clRed;

	if DM.ADOConnection1.Connected then
   begin
      Shape.Brush.Color := clGreen;
   end;
end;

procedure TFMain.FormShow(Sender: TObject);
begin
   DBGrid1.Align := alClient;
end;

procedure TFMain.Start();
var
	LNazwisko : TStringList;
   LImie     : TStringList;
   LUlica    : TStringList;
   LKodp     : TStringList;
   LMiasto   : TStringList;

   lp        : Integer;

begin
	LNazwisko := TStringList.Create();
   LImie     := TStringList.Create();
   LUlica    := TStringList.Create();
   LKodp     := TStringList.Create();
   LMiasto   := TStringList.Create();


	DM.ADOQuery1.First();

   while not DM.ADOQuery1.Eof do
   begin
      LNazwisko.Add(DM.ADOQuery1.FieldByName('nazwisko').AsString);
      LImie.Add(DM.ADOQuery1.FieldByName('imie').AsString);
      LUlica.Add(DM.ADOQuery1.FieldByName('ulicainr').AsString);
      LKodp.Add(DM.ADOQuery1.FieldByName('kodp').AsString);
      LMiasto.Add(DM.ADOQuery1.FieldByName('miasto').AsString);

		DM.ADOQuery1.Next();
   end;

	DM.ADOQuery1.First();

   if LNazwisko.Count > 0  then
   begin
   	Drukuj(Lnazwisko, LImie, LUlica, LKodp, LMiasto);
   end;
   
	LNazwisko.Clear();
	FreeAndNil(LNazwisko);
   LImie.Clear();
   FreeAndNil(LImie);
   LUlica.Clear();
   FreeAndNil(LUlica);
   LKodp.Clear();
   FreeAndNil(LKodp);
   LMiasto.Clear();
   FreeAndNil(LMiasto);
end;

procedure TFMain.Drukuj(LNazwisko : TStringList;
                        LImie     : TStringList;
                        LUlica    : TStringList;
                        LKodp     : TStringList;
                        LMiasto   : TStringList);
var
	ob : MPrint;

begin
	ob := MPrint.Create(LNazwisko,
                       LImie,
                       LUlica,
                       LKodp,
                       LMiasto);
	ob.Drukuj();

	FreeAndNil(ob);
end;

end.

